/**
 * 
 */
package com.ejie.ab18a.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;

import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.ab18a.properties.Ab18aPropertiesManager;

/**
 * @author XXXX
 * 
 */
public class Ab18aAccesoWS {
	/**
	 * Instantiates a new y46j acceso ws.
	 */
	private Ab18aAccesoWS() {
	}

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aAccesoWS.class);

	/**
	 * Obtener informacion ws.
	 * 
	 * @param metodo
	 *            the metodo
	 * @param params
	 *            the params
	 * @param values
	 *            the values
	 * @return the string
	 * @throws Exception
	 *             the exception
	 */
	public static String obtenerInformacionWS(String metodo, String[] params, String[] values) throws Exception {

		Ab18aAccesoWS.logger.debug("Entramos en obtenerInformacionWS...");
		String xmlRetorno = null;
		try {
			String targetNameSpace = Ab18aPropertiesManager.getProperty("namespace.perfil");
			String url_jws = Ab18aPropertiesManager.getProperty("wsdl.perfil");
			// Creamos el mensaje SOAP
			MessageFactory mfactory = MessageFactory.newInstance();
			SOAPMessage message = mfactory.createMessage();

			// 0096321: Soporte a la virtualización de Revascón
			MimeHeaders mimeheader = new MimeHeaders();
			mimeheader.addHeader("Content-Type", "text/xml; charset=utf-8");
			ByteArrayOutputStream myByteArrayOutputString = new ByteArrayOutputStream();
			message.writeTo(myByteArrayOutputString);
			message = mfactory.createMessage(mimeheader, new ByteArrayInputStream(myByteArrayOutputString.toByteArray()));

			// Conseguimos la parte SOAP del mensaje
			SOAPPart soapPart = message.getSOAPPart();
			SOAPEnvelope envelope = soapPart.getEnvelope();
			SOAPBody body = envelope.getBody();

			// conseguimos el tsname del metodo que vamos a invocar.
			Name name = envelope.createName(metodo, Ab18aPropertiesManager.getProperty("webservice.name"), targetNameSpace);
			SOAPBodyElement element = body.addBodyElement(name);

			for (int i = 0; i < params.length && i < values.length; i++) {
				SOAPElement param = element.addChildElement(envelope.createName(params[i]));
				param.addTextNode(values[i]);
			}

			// Conseguimos una conexion SOAP
			SOAPConnectionFactory factory = SOAPConnectionFactory.newInstance();
			SOAPConnection con = factory.createConnection();
			Ab18aAccesoWS.logger.debug("Hacemos la llamada SOAP y recuperamos la respuesta ...");
			// Hacemos la llamada SOAP y recuperamos la respuesta
			SOAPMessage response = con.call(message, url_jws);

			// Miramos si ha ido bien la ejecucion de la llamada y si es así
			// lo
			// pasamos a String.
			xmlRetorno = Ab18aAccesoWS.getResultado(response);

		} catch (Exception ex) {
			xmlRetorno = null;
			Ab18aAccesoWS.logger.error("Se ha producido un error en obtenerInformacionWS... ", ex);
			throw new Exception(ex);
		}
		Ab18aAccesoWS.logger.debug("Fin de obtenerInformacionWS...");
		return xmlRetorno;

	}

	/**
	 * Gets the resultado.
	 * 
	 * @param response
	 *            the response
	 * @return the resultado
	 * @throws javax.xml.ws.soap.SOAPFaultException
	 *             the sOAP fault exception
	 * @throws Exception
	 *             the exception
	 */
	private static String getResultado(SOAPMessage response) throws javax.xml.ws.soap.SOAPFaultException, Exception {
		StringBuffer rtdo = new StringBuffer("");

		SOAPBodyElement soapBodyElement = Ab18aAccesoWS.getSOAPBodyElement(response);
		if (soapBodyElement instanceof SOAPBodyElement) {
			// Todo ha ido OK, recogemos el resultado
			Iterator<?> iterator = soapBodyElement.getChildElements();
			while (iterator.hasNext()) {
				SOAPElement element = (SOAPElement) iterator.next();
				rtdo.append(element.getValue());
			}
		} else {
			SOAPFault fault = (SOAPFault) soapBodyElement;
			Ab18aAccesoWS.tratarSOAPFault(fault);
		}

		return rtdo.toString();
	}

	/**
	 * Tratar soap fault.
	 * 
	 * @param fault
	 *            the fault
	 * @throws Exception
	 *             the exception
	 */
	private static void tratarSOAPFault(SOAPFault fault) throws Exception {
		StringBuffer mensajeError = new StringBuffer(Constantes.NUMERO_44);
		mensajeError.append("SOAPFault:\n");
		mensajeError.append(fault.getFaultActor());
		mensajeError.append("  faultCode: ");
		mensajeError.append(fault.getFaultCode());
		mensajeError.append("\n");
		mensajeError.append("  faultString: ");
		mensajeError.append(fault.getFaultString());
		mensajeError.append("\n");
		Detail detail = fault.getDetail();
		StringBuffer detailValue = new StringBuffer(Constantes.NUMERO_17);
		Iterator<?> it = detail.getDetailEntries();
		while (it.hasNext()) {
			DetailEntry detailEntry = (DetailEntry) it.next();
			detailValue.append("  detailEntry: " + detailEntry.getValue() + "\n");
		}
		throw new Exception(mensajeError.toString());
	}

	/**
	 * Gets the sOAP body element.
	 * 
	 * @param response
	 *            the response
	 * @return the sOAP body element
	 * @throws SOAPException
	 *             the sOAP exception
	 */
	public static SOAPBodyElement getSOAPBodyElement(SOAPMessage response) throws SOAPException {
		SOAPBodyElement rtdo = null;
		Iterator<?> iterator = response.getSOAPPart().getEnvelope().getBody().getChildElements();
		while (iterator.hasNext()) {
			Object oUndefined = iterator.next();
			if (oUndefined instanceof SOAPBodyElement) {
				rtdo = (SOAPBodyElement) oUndefined;
				break;
			}
		}
		return rtdo;
	}

	/**
	 * Obtener informacion wsroc.
	 * 
	 * @param metodo
	 *            the metodo
	 * @param params
	 *            the params
	 * @param values
	 *            the values
	 * @return the string
	 * @throws Exception
	 *             the exception
	 */
	public static String obtenerInformacionWSROC(String metodo, String[] params, String[] values) throws Exception {
		Ab18aAccesoWS.logger.debug("Entramos en obtenerInformacionWSROC...");

		String xmlRetorno = null;
		try {
			String targetNameSpace = Ab18aPropertiesManager.getProperty("namespace.roc");
			// String url_jws = Y46jConstantes.URL_PERFIL_WS;
			String url_jws = Ab18aPropertiesManager.getProperty("wsdl.ROC");
			// Creamos el mensaje SOAP
			MessageFactory mfactory = MessageFactory.newInstance();
			SOAPMessage message = mfactory.createMessage();

			MimeHeaders mimeheader = new MimeHeaders();
			mimeheader.addHeader("Content-Type", "text/xml; charset=utf-8");
			ByteArrayOutputStream myByteArrayOutputString = new ByteArrayOutputStream();
			message.writeTo(myByteArrayOutputString);
			message = mfactory.createMessage(mimeheader, new ByteArrayInputStream(myByteArrayOutputString.toByteArray()));

			// Conseguimos la parte SOAP del mensaje
			SOAPPart soapPart = message.getSOAPPart();
			SOAPEnvelope envelope = soapPart.getEnvelope();
			SOAPBody body = envelope.getBody();

			// conseguimos el tsname del metodo que vamos a invocar.
			Name name = envelope.createName(metodo, Ab18aPropertiesManager.getProperty("webservice.name.roc"), targetNameSpace);
			SOAPBodyElement element = body.addBodyElement(name);

			for (int i = 0; i < params.length && i < values.length; i++) {
				SOAPElement param = element.addChildElement(envelope.createName(params[i]));
				param.addTextNode(values[i]);
			}

			// Conseguimos una conexion SOAP
			SOAPConnectionFactory factory = SOAPConnectionFactory.newInstance();
			SOAPConnection con = factory.createConnection();

			// Hacemos la llamada SOAP y recuperamos la respuesta
			SOAPMessage response = null;
			response = con.call(message, url_jws);
			Ab18aAccesoWS.logger.debug("obtenerInformacionWSROC:: Hecha la llamada SOAP");
			// Miramos si ha ido bien la ejecucion de la llamada y si es as�
			// lo
			// pasamos a String.

			xmlRetorno = Ab18aAccesoWS.getResultado(response);

			Ab18aAccesoWS.logger.debug("obtenerInformacionWSROC:: Hecha la llamada SOAP xmlRetorno " + xmlRetorno);

		} catch (Exception ex) {
			xmlRetorno = null;
			Ab18aAccesoWS.logger.error("Se ha producido un error en obtenerInformacionWSROC... ", ex);
			throw new Exception(ex);
		}
		Ab18aAccesoWS.logger.debug("Fin de obtenerInformacionWSROC...");
		return xmlRetorno;

	}

}
